import logging
import requests
import time

from sandbox import sdk2

from sandbox.projects.common import network
from sandbox.sandboxsdk.network import is_port_free

from sandbox.sdk2.helpers import subprocess as sp


class ServerWrapper(object):
    name = 'server'

    def __init__(self):
        self.port = network.get_free_port()

    def start(self, *args):
        # Run subprocess
        self.process_log = sdk2.helpers.ProcessLog(sdk2.Task.current, logger='{}.log'.format(self.name))
        self.process = sp.Popen(
            args,
            stdout=self.process_log.stdout,
            stderr=sp.STDOUT,
        )

        # Wait for exit if something is wrong
        while is_port_free(self.port):
            time.sleep(1)
            poll_result = self.process.poll()
            if poll_result is not None:
                raise RuntimeError('Error in starting {}'.format(self.name))

        # While not ready for shooting
        while True:
            time.sleep(1)
            res = requests.request(method='GET', url='http://localhost:{}/{}'.format(self.port, self.health_path))
            if res.ok:
                logging.info('Started {} on port {}'.format(self.name, self.port))
                return

    def get_port(self):
        return self.port


class BasesearchRecommender(ServerWrapper):
    name = 'basesearch'
    health_path = 'yandsearch'

    def __init__(self, basesearch_path, basesearch_conf_path, shard_path):
        super(BasesearchRecommender, self).__init__()

        self.start(
            basesearch_path,
            "-p", str(self.port),
            "-V", "IndexDir=" + shard_path,
            "-d",
            basesearch_conf_path
        )


class MiddlesearchRecommender(ServerWrapper):
    name = 'middlesearch'
    health_path = 'yandsearch'

    def __init__(self, middlesearch_path, middlesearch_conf_path):
        super(MiddlesearchRecommender, self).__init__()

        self.start(
            middlesearch_path,
            "-p", str(self.port),
            "-d", middlesearch_conf_path,
            "-V CONFIG=" + middlesearch_conf_path
        )
