from sandbox import sdk2


class AutoruDjResourceBase(sdk2.Resource):
    releasers = [
        "robot-testenv",
        "vkokhtev",
        "paulkovalenko",
        "ieboytsov"
        "robot-vertis-ml",
    ]

class AutoruDjShard(AutoruDjResourceBase):
    """
        Autoru recommender index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class AutoruDjModels(AutoruDjResourceBase):
    """
        Directory with models
    """
    releasable = True
    executable = False
