import time

from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sandboxsdk import network
from sandbox.projects.dj.services.chz.instances import base


class ChzRecommenderSandboxRunnerMixin:
    def _launch_process(self):
        self.process = sp.Popen(args=self.args, **self.popen_args)
        time.sleep(10)
        while network.is_port_free(self.http_port):
            time.sleep(10)
            if self.process.poll() is not None:
                raise RuntimeError("Error in Chz Recommender starting")


class ChzRecommenderInSandbox(ChzRecommenderSandboxRunnerMixin, base.ChzRecommenderBase):
    pass
