import attr
import copy

from sandbox import sdk2
from sandbox.sdk2 import helpers as sdk_helpers

from sandbox.projects.dj.services.chz.specs import const
from sandbox.projects.dj.services.chz.specs import specs


def _spec_to_task_parameters_declaration(spec_type, recommender_title):
    class ResultParameters(sdk2.Task.Parameters):
        for resource_attrib in attr.fields(spec_type):
            sdk_helpers.set_parameter(
                name=resource_attrib.name,
                parameter=sdk2.parameters.Resource(
                    'Resource {} for recommender {}'.format(resource_attrib.name, recommender_title),
                    resource_type=sdk2.Resource[resource_attrib.metadata[const.RESOURCE_TYPE_ATTR]],
                )
            )

    return ResultParameters


def _find_last_resource_in_sdk(*args, **kwargs):
    return sdk2.Resource.find(*args, **kwargs).limit(1).first()


def _find_last_resource(resource_attrib):
    lookup_attrs = copy.deepcopy(resource_attrib.metadata[const.SANDBOX_EXTRA_ATTRIBUTES_ATTR])
    lookup_attrs.setdefault('released', 'stable')

    return _find_last_resource_in_sdk(
        resource_attrib.metadata[const.RESOURCE_TYPE_ATTR],
        attrs=lookup_attrs
    )


def spec_object_from_parameters_with_defaults(parameters, spec_type):
    kwargs = {
        resource_attrib.name: (
            getattr(parameters, resource_attrib.name) or _find_last_resource(resource_attrib)
        )
        for resource_attrib in attr.fields(spec_type)
    }

    return spec_type(**kwargs)


chz_daemon_parameters = _spec_to_task_parameters_declaration(
    specs.ChzRecommenderSpec,
    recommender_title='chz'
)
