import attr
from sandbox import sdk2

from sandbox.projects.dj.services.chz.specs import specs


def get_resource_data(resource):
    return sdk2.ResourceData(resource)


def download_spec_resources(spec_object):
    spec_cls = type(spec_object)

    files_spec_args = {
        resource_field.name: get_resource_data(getattr(spec_object, resource_field.name)).path
        for resource_field in attr.fields(spec_cls)
    }

    return spec_cls(**files_spec_args)
