import attr


from sandbox.projects.dj.services.chz.specs import const


def make_resource_attrib(resource_type, untar=False, link=True, sandbox_extra_attrs=None, **kwargs):
    assert(untar != link)

    # kwargs.setdefault('type', int)

    metadata = kwargs.setdefault('metadata', {})
    metadata[const.RESOURCE_TYPE_ATTR] = resource_type
    metadata[const.UNTAR_ATTR] = untar
    metadata[const.LINK_ATTR] = link

    metadata.setdefault(const.SANDBOX_EXTRA_ATTRIBUTES_ATTR, sandbox_extra_attrs or {})

    return attr.ib(**kwargs)


@attr.s
class ChzRecommenderSpec(object):
    bundle = make_resource_attrib(
        resource_type='CHZ_DJ_RECOMMENDER_PACKAGE',
        untar=True,
        link=False,
    )
    shard = make_resource_attrib(resource_type='CHZ_DJ_SHARD')
    model_menu = make_resource_attrib(resource_type='CHZ_MENU_ITEMS_RANK_MODEL')
    extended_model_menu = make_resource_attrib(
        resource_type='CHZ_MENU_ITEMS_RANK_MODEL',
        sandbox_extra_attrs={
            'slot': '01',
            'released': 'testing',
        }
    )
