import attr

from sandbox.projects.dj.services.chz.specs import const
from sandbox.projects.dj.services.chz.specs import specs


def select_spec_items(spec_object, pred):
    for resource_field in attr.fields(type(spec_object)):
        resource_value = getattr(spec_object, resource_field.name)
        if pred(resource_field, resource_value):
            yield resource_field, resource_value


def select_from_spec_by_metadata_flag(spec_object, metadata_flag):
    return select_spec_items(
        spec_object,
        pred=lambda f, _v: f.metadata[metadata_flag]
    )


def lookup_resource_type_in_metadata(spec_type, spec_resource_name):
    resource_field = next(
        (
            resource_field
            for resource_field in attr.fields(spec_type)
            if resource_field.name == spec_resource_name
        ),
        None
    )

    err_msg = "Unexpected name {} for spec type {}".format(spec_resource_name, specs.ChzRecommenderSpec)
    assert resource_field is not None, err_msg

    return resource_field.metadata[const.RESOURCE_TYPE_ATTR]
