import shutil
from sandbox.sdk2.parameters import Resource
from sandbox.sdk2 import ResourceData
from sandbox.sdk2 import Task
from sandbox.projects.common.nanny import nanny
from sandbox.projects.dj.services.entity.resources import EntityRecommenderModels

class EntityRecommenderMakeModels(nanny.ReleaseToNannyTask2, Task):
    class Parameters(Task.Parameters):
        models_resource = Resource("Resource with archived Entity Recommender models", required = True)

    class Requirements(Task.Requirements):
        ram = 1 * 1024
        disk_space = 1 * 1024

    def on_execute(self):
        er_models_data = ResourceData(EntityRecommenderModels(self, "Catboost models", "models.tar.gz"))
        models_data = ResourceData(self.Parameters.models_resource)
        shutil.copyfile(str(models_data.path), str(er_models_data.path))
        er_models_data.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        Task.on_release(self, additional_parameters)
