import tarfile
from sandbox.sdk2.parameters import RadioGroup
from sandbox.sdk2.parameters import Resource
from sandbox.sdk2 import ResourceData
from sandbox.sdk2 import Task
from sandbox.projects.dj.services.entity.resources import EntityRecommenderShard
from sandbox.projects.dj.services.entity.resources import EntityRecommenderShardArchive
from sandbox.projects.dj.services.entity.resources import EntityRecommenderTestShard
from sandbox.projects.dj.services.entity.resources import EntityRecommenderTestShardArchive

class EntityRecommenderMakeShardArchive(Task):
    class Context(Task.Context):
        shard_type = None
        shard_id = None

    class Parameters(Task.Parameters):
        with RadioGroup("Shard type") as shard_type:
            shard_type.values.prod = shard_type.Value("prod")
            shard_type.values.test = shard_type.Value("test")
        with shard_type.value["prod"]:
            prod_shard = Resource("Prod shard resoruce", resource_type=EntityRecommenderShard)
        with shard_type.value["test"]:
            test_shard = Resource("Test shard resource", resource_type=EntityRecommenderTestShard)

    class Requirements(Task.Requirements):
        ram = 1 * 1024
        disk_space = 1 * 1024

    def on_execute(self):
        self.stage_init_context()
        self.stage_make_shard_archive()

    def stage_init_context(self):
        shard_type = self.get_param_shard_type()
        shard_resource = self.get_shard_resource()
        context = self.Context
        context.shard_type = shard_type
        context.shard_id = self.get_shard_id()

    def stage_make_shard_archive(self):
        shard_data = self.get_shard_data()
        shard_archive_data = self.make_shard_archive_data()
        with tarfile.open(str(shard_archive_data.path), "w:gz") as output_archive:
            output_archive.add(str(shard_data.path), arcname="index_shard")
        shard_archive_data.ready()

    def make_shard_archive_data(self):
        shard_archive_resource = self.make_shard_archive_resource()
        return ResourceData(shard_archive_resource)

    def make_shard_archive_resource(self):
        shard_type = self.get_param_shard_type()
        shard_archive_resource_type_by_shard_type = {
            "prod": EntityRecommenderShardArchive,
            "test": EntityRecommenderTestShardArchive,
        }
        shard_archive_resource_type = shard_archive_resource_type_by_shard_type[shard_type]
        shard_id = self.get_shard_id()
        shard_archive_description = "Shard archive of {shard_id}".format(shard_id=shard_id)
        shard_archive_filename = "index_shard.tar.gz"
        return shard_archive_resource_type(self, shard_archive_description,
                                           shard_archive_filename, shard_id=shard_id)

    def get_shard_data(self):
        shard_resource = self.get_shard_resource()
        shard_data = ResourceData(shard_resource)
        return shard_data

    def get_shard_id(self):
        shard_resource = self.get_shard_resource()
        return shard_resource.id

    def get_shard_resource(self):
        shard_type = self.get_param_shard_type()
        shard_resource_by_type = {
            "prod": self.get_param_prod_shard(),
            "test": self.get_param_test_shard(),
        }
        return shard_resource_by_type[shard_type]

    def get_param_shard_type(self):
        parameters = self.Parameters
        return parameters.shard_type

    def get_param_prod_shard(self):
        parameters = self.Parameters
        return parameters.prod_shard

    def get_param_test_shard(self):
        parameters = self.Parameters
        return parameters.test_shard

