import requests
import json
import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.sdk2.parameters import String
from sandbox.sdk2 import Task
from sandbox.sdk2 import Vault
from sandbox.sdk2 import yav


class EntityRecommenderSlackNotify(Task):
    """ Send message to Slack channel """

    class Parameters(Task.Parameters):
        webhook = String("yav slack webhook secret id", required=True)
        message = String("Message json (see Slack API)", multiline=True, required=True, default="{}")

    class Context(Task.Context):
        message = None
        response = None

    class Requirements(Task.Requirements):
        dns = ctm.DnsType.DNS64

    def on_execute(self):
        message = self.make_message()
        url = self.make_url()
        response = self.send_message(url, message)
        self.update_context(message, response)
        self.handle_response(response)

    def make_message(self):
        parameters = self.Parameters
        message = json.loads(parameters.message)
        return message

    def make_url(self):
        parameters = self.Parameters
        webhook = yav.Secret(parameters.webhook).data()["ya-ontology-slack-token"]
        url = "https://hooks.slack.com/services/{webhook}".format(webhook=webhook)
        return url

    def send_message(self, url, message):
        return requests.post(url, data=json.dumps(message), headers={'Content-Type': 'application/json'})

    def update_context(self, message, response):
        context = self.Context
        context.message = message
        context.response = response.text

    def handle_response(self, response):
        response.raise_for_status()

