from sandbox import sdk2
from sandbox.sdk2.parameters import Integer
from sandbox.sdk2.parameters import String
from sandbox.projects.resource_types.releasers import entitysearch_releasers
from sandbox.projects.resource_types.releasers import vh_recommender_releasers


class EntityRecommenderResourceBase(sdk2.Resource):
    releasers = entitysearch_releasers + vh_recommender_releasers


class EntityRecommenderAmmoResourceBase(EntityRecommenderResourceBase):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    group = String("Plan group")
    requests_count = Integer("Count of requests", required=True)
    ammo_type = String("Type of ammo", required=True)
    experiment = String("Experiment name", required=True)


class EntityRecommenderTextQueries(EntityRecommenderAmmoResourceBase):
    """
        Entity recommender text queries
    """
    pass


class EntityRecommenderShootingPlan(EntityRecommenderAmmoResourceBase):
    """
        Entity recommender plan
    """
    pass


class EntityRecommenderShard(EntityRecommenderResourceBase):
    """
        Entity recommender index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class EntityRecommenderTestShard(EntityRecommenderResourceBase):
    """
        Entity recommender test index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class EntityRecommenderShard2(EntityRecommenderResourceBase):
    """
        Entity recommender shard 2.0
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


class EntityRecommenderTestShard2(EntityRecommenderResourceBase):
    """
        Entity recommender test shard 2.0
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


class EntityRecommenderShardArchive(EntityRecommenderResourceBase):
    """
        Entity recommender archived index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard_id = Integer("Parent shard resoruce id", required=True)


class EntityRecommenderTestShardArchive(EntityRecommenderResourceBase):
    """
        Entity recommender archived test index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard_id = Integer("Parent shard resoruce id", required=True)


class EntityRecommenderModels(EntityRecommenderResourceBase):
    """
        Entity recommender models
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


class EntityRecommenderArcadiaModels(EntityRecommenderResourceBase):
    """
        Entity recommender models in arcadia
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


class EntityRecommenderArcadiaDeepModel(EntityRecommenderResourceBase):
    """
        Entity recommender models in arcadia
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


class EntityRecommenderAlsShard(EntityRecommenderResourceBase):
    """
        Resource for ALS processing
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


class EntityRecommenderShardmap(EntityRecommenderResourceBase):
    """
        Entity recommender index shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shardmap = True


class EntityRecommender(EntityRecommenderResourceBase):
    """
        Entity recommender service
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'entity/recommender/runtime/app'
    arcadia_build_name = 'entity_recommender_service'


class EntityRecommenderBundle(EntityRecommenderResourceBase):

    """
       Bundle for entity recommender deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class EntityRecommenderYqlUdf(EntityRecommenderResourceBase):
    """
        YQL UDF.
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
