from sandbox import sdk2


class GoodsRecommenderResourceBase(sdk2.Resource):
    releasers = [
        "robot-mlp-morpheus",
        "mincer",
        "vvp",
        "dskor"
    ]


class GoodsRecommenderShard(GoodsRecommenderResourceBase):
    """
        Goods recommender index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class GoodsRecommenderShardmap(GoodsRecommenderResourceBase):
    """
        Goods recommender index shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shardmap = True
