from sandbox import sdk2
from sandbox import common
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.dj.services.mail_sc.resources import MailScBans
from sandbox.projects import resource_types


class SmartComposeBuildBanTrie(nanny.ReleaseToNannyTask2, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        builder_resource = sdk2.parameters.Resource(
            "Smart Compose ban trie builder resource",
            resource_type=resource_types.ARCADIA_PROJECT_BINARY,
            required=True
        )
        arcadia_ban_list_path = sdk2.parameters.String(
            "Path to arcadia file with ban list",
            required=True
        )

    def on_execute(self):
        builder_resource_data = sdk2.ResourceData(self.Parameters.builder_resource)
        builder_path = str(builder_resource_data.path)

        ban_list_file_path = "./ban_list"
        Arcadia.export(self.Parameters.arcadia_ban_list_path, ban_list_file_path)

        trie_file = "./bans.trie"

        with sdk2.helpers.ProcessLog(self, logger="ban_trie_builder_log") as pl:
            ret_code = sp.Popen(
                [
                    builder_path,
                    "--input", ban_list_file_path,
                    "--output", trie_file
                ],
                stdout=pl.stdout, stderr=sp.STDOUT
            ).wait()
            if ret_code != 0:
                raise common.errors.TaskFailure('Builder run failed')

        sdk2.ResourceData(MailScBans(self, self.Parameters.description, trie_file)).ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
