
from sandbox import sdk2
from sandbox.projects.dj.services.mail_sc.resources import SmartComposeQuality
from sandbox.projects.dj.services.mail_sc.resources import SmartComposeQualityDiff

import json


class SmartComposeCompareQuality(sdk2.Task):
    """ Task for comparing Smart Compose quality """

    class Parameters(sdk2.Task.Parameters):
        task1_resource = sdk2.parameters.Resource(
            "Resource Recommender quality stats",
            resource_type=SmartComposeQuality,
            required=True
        )
        task2_resource = sdk2.parameters.Resource(
            "Resource Recommender quality stats",
            resource_type=SmartComposeQuality,
            required=True
        )
        max_delta = sdk2.parameters.Integer("Max delta between metrics in percents", default=1, required=True)

    def on_execute(self):
        task1_resource_data = sdk2.ResourceData(self.Parameters.task1_resource)
        task2_resource_data = sdk2.ResourceData(self.Parameters.task2_resource)

        with open(str(task1_resource_data.path)) as f1, \
             open(str(task2_resource_data.path)) as f2:
            task1_stats = json.load(f1)
            task2_stats = json.load(f2)

        self.Context.sdiff = {}

        has_diff = [0] * len(task1_stats)
        for i in range(len(task1_stats)):
            name = task1_stats[i]["metric"]
            if name == 'rps':
                continue
            v1 = task1_stats[i]["value"]
            v2 = task2_stats[i]["value"]
            has_diff[i] = abs(v1 - v2) > v1 * self.Parameters.max_delta / 100

            self.Context.sdiff[name] = {
                "task1": v1,
                "task2": v2
            }

        self.Context.has_diff = any(has_diff)  # self.Context.delta > self.Context.task1_rps * self.Parameters.max_delta / 100
        if self.Context.has_diff:
            diff_resource = SmartComposeQualityDiff(
                self,
                "Smart Compose quality diff",
                "quality_diff.json"
            )
            diff_resource_data = sdk2.ResourceData(diff_resource)
            with open(str(diff_resource_data.path), 'w') as diff_file:
                diff_file.write(json.dumps(self.Context.sdiff))
            diff_resource_data.ready()

    @sdk2.header()
    def header(self):
        if self.Context.has_diff:
            report = "Diffs in this: <br/>"
            for name in self.Context.sdiff:
                report += '%s: %s -> %s <br/>' % (name, self.Context.sdiff[name]['task1'], self.Context.sdiff[name]['task2'])
            return report
        return 'These Are Not the Diffs You Are Looking For'
