from sandbox import sdk2

from sandbox.projects.dj.services.mail_sc.resources import SmartComposeResponses
from sandbox.projects.dj.services.mail_sc.resources import SmartComposeResponsesDiff

import json


class SmartComposeCompareResponses(sdk2.Task):
    """ Task for comparing Smart Compose responses """

    class Parameters(sdk2.Task.Parameters):
        task1_resource = sdk2.parameters.Resource(
            "Resource with Smart Compose responses",
            resource_type=SmartComposeResponses,
            required=True
        )
        task2_resource = sdk2.parameters.Resource(
            "Resource with Smart Compose responses",
            resource_type=SmartComposeResponses,
            required=True
        )

    def load_responses(self, file_path):
        with open(file_path, 'r') as f:
            raw_responses = f.readlines()
            return [json.loads(r.strip()) for r in raw_responses]

    def build_diff_message(self, field_name, card1, card2):
        return "Different value of field '{}'. Left: {}. Right: {}".format(
            field_name,
            card1[field_name],
            card2[field_name]
        )

    def compare_replies(self, card1, card2):
        for field in ('text', 'id'):
            if (field in card1) != (field in card2):
                return "Different presence of field '{}' in responses".format(field)
            if field in card1 and card1[field] != card2[field]:
                return self.build_diff_message(field, card1, card2)

    def compare_responses(self, response1, response2):
        cards1 = response1["items"]
        cards2 = response2["items"]

        if cards1 != cards2:
            return {
                "request_text": response1.get('request_text'),
                "left": cards1,
                "right": cards2
            }

        return None

    def calc_diff(self, responses1, responses2):
        diff = []

        if len(responses1) != len(responses2):
            diff.append({
                "diff": "Different count of responses",
                "left": responses1,
                "right": responses2
            })
            return diff

        for i in range(0, len(responses1)):
            response_diff = self.compare_responses(responses1[i], responses2[i])
            if response_diff is not None:
                diff.append(response_diff)

        return diff

    def on_execute(self):
        task1_resource_data = sdk2.ResourceData(self.Parameters.task1_resource)
        task2_resource_data = sdk2.ResourceData(self.Parameters.task2_resource)

        responses1 = self.load_responses(str(task1_resource_data.path))
        responses2 = self.load_responses(str(task2_resource_data.path))

        diff = self.calc_diff(responses1, responses2)

        if len(diff) > 0:
            diff_resource = SmartComposeResponsesDiff(
                self,
                "Smart Compose responses diff",
                "responses_diff.json"
            )
            diff_resouce_data = sdk2.ResourceData(diff_resource)
            with open(str(diff_resouce_data.path), 'w') as diff_file:
                diff_file.write(json.dumps(diff, ensure_ascii=False))
            diff_resouce_data.ready()

        self.Context.has_diff = len(diff) > 0

    @sdk2.header()
    def header(self):
        if self.Context.has_diff:
            return "Some diff! Watch diff-resourse pls"
        return 'These Are Not the Diffs You Are Looking For'
