
from sandbox import sdk2

from sandbox.projects.dj.services.mail_sc.resources import MailScBundle
from sandbox.projects.dj.services.mail_sc.resources import SmartComposeQuality
from sandbox.projects.dj.services.mail_sc.components import SmartComposeRecommender

from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects import resource_types

import sandbox.common.types.client as ctc


class SmartComposeGetQuality(sdk2.Task):
    """ Task for fetching Smart Compose quality """

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX
        ram = 50 * 1024
        disk_space = 100 * 1024

    class Parameters(sdk2.Task.Parameters):
        smart_compose_server_port = sdk2.parameters.Integer("Port for Smart Compose server",
                                                            default=15358,
                                                            required=True)

        bundle_resource = sdk2.parameters.Resource(
            "Resource with Smart Compose bundle",
            resource_type=MailScBundle,
            required=True
        )
        queries_resource = sdk2.parameters.Resource(
            "Resource with queries",
            resource_type=resource_types.OTHER_RESOURCE,
            required=True
        )
        quality_tool = sdk2.parameters.Resource(
            "Resource with tool for calc metrics",
            resource_type=resource_types.ARCADIA_PROJECT_BINARY,
            required=True
        )

    def on_execute(self):
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)
        quality_tool = sdk2.ResourceData(self.Parameters.quality_tool)

        recommender = SmartComposeRecommender(self,
                                              str(bundle_resource_data.path),
                                              self.Parameters.smart_compose_server_port)

        queries_resource_data = sdk2.ResourceData(self.Parameters.queries_resource)

        responses_resource = SmartComposeQuality(self, "Smart Compose quality", "responses.json")
        responses_resource_data = sdk2.ResourceData(responses_resource)

        sp.call(
            [
                str(quality_tool.path),
                '--host', 'localhost:%s' % self.Parameters.smart_compose_server_port,
                '--experiment', 'prod',
                '--input-file', str(queries_resource_data.path),
                '--output-file', str(responses_resource_data.path),
                '--pool', 'bbs',
                '--calc-metrics',
                '--protocol', 'http',
            ]
        )

        responses_resource_data.ready()
        recommender.close()
