from sandbox import sdk2

from sandbox.projects.dj.services.mail_sc.resources import MailScBundle
from sandbox.projects.dj.services.mail_sc.resources import SmartComposeResponses
from sandbox.projects.dj.services.mail_sc.components import SmartComposeRecommender

from sandbox.projects.tank.load_resources.resources import AMMO_FILE
from sandbox.projects import resource_types
from sandbox.sdk2.helpers import subprocess as sp

import sandbox.common.types.client as ctc


class SmartComposeGetResponses(sdk2.Task):
    """ Task for fetching Smart Compose responses """

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX
        ram = 50 * 1024
        disk_space = 100 * 1024

    class Parameters(sdk2.Task.Parameters):
        recommender_port = sdk2.parameters.Integer("Port for Smart Compose server",
                                                          default=15358,
                                                          required=True)
        request_count = sdk2.parameters.Integer("Count of requests", default=1000, required=True)

        bundle_resource = sdk2.parameters.Resource(
            "Resource with Smart Compose bundle",
            resource_type=MailScBundle,
            required=True
        )
        queries_resource = sdk2.parameters.Resource(
            "Resource with queries",
            resource_type=AMMO_FILE,
            required=True
        )
        st_shooter_resource = sdk2.parameters.Resource(
            "Resource with shooter binary",
            resource_type=resource_types.ARCADIA_PROJECT_BINARY,
            required=True
        )

    def on_execute(self):
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)

        recommender = SmartComposeRecommender(self,
                                              str(bundle_resource_data.path),
                                              self.Parameters.recommender_port)

        queries_resource_data = sdk2.ResourceData(self.Parameters.queries_resource)

        responses_resource = SmartComposeResponses(self, "Smart Compose responses", "responses.txt")
        responses_resource_data = sdk2.ResourceData(responses_resource)

        st_shooter_data = sdk2.ResourceData(self.Parameters.st_shooter_resource)
        sp.call(
            [
                str(st_shooter_data.path),
                '-f', str(queries_resource_data.path),
                'localhost', str(self.Parameters.recommender_port),
                '-n', str(self.Parameters.request_count),
                '-o', str(responses_resource_data.path),
            ]
        )
        responses_resource_data.ready()

        recommender.close()
