from sandbox import sdk2


class MailScResourceBase(sdk2.Resource):
    releasers = [
        'dronte',
        'levobuhov',
        'vvp',
        'mihaild',
        'mrtsepa',
        'plato',
        'crossby',
    ]


class MailScShard(MailScResourceBase):
    """
        Mail Smart Compose index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class MailScShardmap(MailScResourceBase):
    """
        Mail Smart Compose index shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shardmap = True


class MailSc(MailScResourceBase):
    """
        Mail Smart Compose service
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'dj/services/mail_sc/runtime/app'
    arcadia_build_name = 'mail_sc_service'


class MailScBundle(MailScResourceBase):
    """
       Bundle for mail smart compose deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SmartComposeResponses(MailScResourceBase):
    """
        Smart Compose responses file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SmartComposeResponsesDiff(MailScResourceBase):
    """
        Smart Compose responses diff file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SmartComposeQuality(MailScResourceBase):
    """
        Smart Compose quality file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SmartComposeQualityDiff(MailScResourceBase):
    """
        Smart Compose quality diff file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class MailScJugglerBundle(MailScResourceBase):
    """
       Juggler Bundle for mail smart compose
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class MailScBans(MailScResourceBase):
    """
        Quick bans for Smart Compose
    """
    auto_backup = True
    releasable = True
