from sandbox import sdk2
from sandbox.projects.dj.services.mail_sr.resources import SmartReplyQuality
from sandbox.projects.dj.services.mail_sr.resources import SmartReplyQualityDiff

import json


class SmartReplyCompareQuality(sdk2.Task):
    """ Task for comparing Smart Reply quality """

    class Parameters(sdk2.Task.Parameters):
        task1_resource = sdk2.parameters.Resource(
            "Resource Recommender quality stats",
            resource_type=SmartReplyQuality,
            required=True
        )
        task2_resource = sdk2.parameters.Resource(
            "Resource Recommender quality stats",
            resource_type=SmartReplyQuality,
            required=True
        )
        max_delta = sdk2.parameters.Integer("Max delta between metrics in percents", default=1, required=True)

    def on_execute(self):
        task1_resource_data = sdk2.ResourceData(self.Parameters.task1_resource)
        task2_resource_data = sdk2.ResourceData(self.Parameters.task2_resource)

        with open(str(task1_resource_data.path)) as f1, \
             open(str(task2_resource_data.path)) as f2:
            task1_stats = json.load(f1)
            task2_stats = json.load(f2)

        self.Context.sdiff = {}
        self.Context.has_diff = False
        for exp in task1_stats:
            self.Context.sdiff[exp] = {}
            for key in task1_stats[exp]:
                val1 = task1_stats[exp][key]
                val2 = task2_stats[exp][key]
                if abs(val1 - val2) >= val1 * self.Parameters.max_delta / 100:
                    self.Context.has_diff = True
                self.Context.sdiff[exp][key] = {
                    "task1": val1,
                    "task2": val2
                }
        if self.Context.has_diff:
            diff_resource = SmartReplyQualityDiff(
                self,
                "Smart Reply quality diff",
                "quality_diff.json"
            )
            diff_resource_data = sdk2.ResourceData(diff_resource)
            with open(str(diff_resource_data.path), 'w') as diff_file:
                diff_file.write(json.dumps(self.Context.sdiff))
            diff_resource_data.ready()

    @sdk2.header()
    def header(self):
        if self.Context.has_diff:
            report = "Diffs in this: <br/>"
            for exp in self.Context.sdiff:
                for name in self.Context.sdiff[exp]:
                    report += '%s.%s: %s -> %s <br/>' % (
                        exp,
                        name,
                        self.Context.sdiff[exp][name]['task1'],
                        self.Context.sdiff[exp][name]['task2']
                    )
            return report
        return 'These Are Not the Diffs You Are Looking For'
