from sandbox import sdk2

from sandbox.projects.dj.services.mail_sr.resources import SmartReplyResponses
from sandbox.projects.dj.services.mail_sr.resources import SmartReplyResponsesDiff

import json


class SmartReplyCompareResponses(sdk2.Task):
    """ Task for comparing Smart Reply responses """

    class Parameters(sdk2.Task.Parameters):
        task1_resource = sdk2.parameters.Resource(
            "Resource with Smart Reply responses",
            resource_type=SmartReplyResponses,
            required=True
        )
        task2_resource = sdk2.parameters.Resource(
            "Resource with Smart Reply responses",
            resource_type=SmartReplyResponses,
            required=True
        )

    def load_responses(self, file_path):
        with open(file_path, 'r') as f:
            raw_responses = f.readlines()
            return [json.loads(r.strip()) for r in raw_responses]

    def build_diff_message(self, field_name, card1, card2):
        return "Different value of field '{}'. Left: {}. Right: {}".format(
            field_name,
            card1[field_name],
            card2[field_name]
        )

    def compare_replies(self, card1, card2):
        for field in ("text",):
            if (field in card1) != (field in card2):
                return "Different presence of field '{}' in responses".format(field)
            if field in card1 and card1[field] != card2[field]:
                return self.build_diff_message(field, card1, card2)

    def compare_responses(self, response1, response2):
        cards1 = response1["items"]
        cards2 = response2["items"]

        if len(cards1) != len(cards2):
            return "Different count of replies in responses. Left: {}. Right: {}".format(
                len(cards1),
                len(cards2)
            )

        for j in range(0, len(cards1)):
            cards_diff = self.compare_replies(cards1[j], cards2[j])
            if cards_diff is not None:
                return cards_diff

        return None

    def calc_diff(self, responses1, responses2):
        diff = []

        if len(responses1) != len(responses2):
            diff.append("Different count of responses")
            return diff

        for i in range(0, len(responses1)):
            response_diff = self.compare_responses(responses1[i], responses2[i])
            if response_diff is not None:
                diff.append("Diff in responses number {}. {}".format(i, response_diff))

        return diff

    def on_execute(self):
        task1_resource_data = sdk2.ResourceData(self.Parameters.task1_resource)
        task2_resource_data = sdk2.ResourceData(self.Parameters.task2_resource)

        responses1 = self.load_responses(str(task1_resource_data.path))
        responses2 = self.load_responses(str(task2_resource_data.path))

        diff = self.calc_diff(responses1, responses2)

        if len(diff) > 0:
            diff_resource = SmartReplyResponsesDiff(
                self,
                "Smart Reply responses diff",
                "responses_diff.txt"
            )
            diff_resouce_data = sdk2.ResourceData(diff_resource)
            with open(str(diff_resouce_data.path), 'w') as diff_file:
                diff_file.write(json.dumps(diff, ensure_ascii=False))
            diff_resouce_data.ready()

        self.Context.has_diff = len(diff) > 0
