import os
from sandbox import sdk2

import sandbox.common.types.client as ctc

from sandbox.projects.dj.services.mail_sr.resources import SmartReplyQualityQueries
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sandboxsdk import environments


class SmartReplyGenerateQualityQueries(sdk2.Task):
    """ Generate resource for SMART_REPLY_GET_QUALITY task """

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX
        ram = 10 * 1024
        disk_space = 10 * 1024
        environments = [
            environments.PipEnvironment("yandex-yt", version="0.9.9"),
        ]

    class Parameters(sdk2.Task.Parameters):
        table_path = sdk2.parameters.String(
            "Table with validation set",
            default="//home/mlp/plato/validate_0311",
            required=True
        )

        yt_proxy = sdk2.parameters.String(
            "YT_PROXY",
            default="arnold",
            required=True
        )

        yt_token_vault_name = sdk2.parameters.String(
            "Yt token vault name",
            default="robot-mlp-private-yt-sandbox-token",
            required=True
        )

        yt_token_vault_owner = sdk2.parameters.String(
            "Yt token vault owner",
            default="robot-mlp-private",
            required=True
        )

    def on_execute(self):
        if self.Parameters.yt_token_vault_owner:
            yt_token = sdk2.Vault.data(
                self.Parameters.yt_token_vault_owner,
                self.Parameters.yt_token_vault_name
            )
        else:
            yt_token = sdk2.Vault.data(self.Parameters.yt_token_vault_name)

        queries_resource = SmartReplyQualityQueries(self, "Smart Reply quality queries", "queries.txt")
        queries_resource_data = sdk2.ResourceData(queries_resource)
        with open(str(queries_resource_data.path), 'w') as fout:
            sp.check_call(
                [
                    'yt',
                    'read-table',
                    '--table', self.Parameters.table_path,
                    '--format', '<encode_utf8=false>json'
                ],
                stdout=fout,
                env=dict(
                    os.environ,
                    YT_PROXY=self.Parameters.yt_proxy,
                    YT_TOKEN=yt_token
                )
            )

        queries_resource_data.ready()
