from sandbox import sdk2

import sandbox.common.types.client as ctc

from sandbox.projects.dj.services.mail_sr.resources import MailSrBundle
from sandbox.projects.dj.services.mail_sr.components import SmartReplyRecommender
from sandbox.projects.dj.services.mail_sr.resources import SmartReplyQuality
from sandbox.projects.dj.services.mail_sr.resources import SmartReplyQualityQueries
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects import resource_types


class SmartReplyGetQuality(sdk2.Task):
    """ Offline metrics calculation for Smart Reply responses """

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX
        ram = 10 * 1024
        disk_space = 10 * 1024

    class Parameters(sdk2.Task.Parameters):
        smart_reply_server_port = sdk2.parameters.Integer(
            "Port for Smart Reply server",
            default=15358,
            required=True
        )

        experiments = sdk2.parameters.List(
            "Requested experiments names",
            default=["toloka_pf"],
            required=True
        )

        queries_resource = sdk2.parameters.Resource(
            "Smart reply validation queries",
            resource_type=SmartReplyQualityQueries,
            required=True
        )

        bundle_resource = sdk2.parameters.Resource(
            "Resource with Smart Reply bundle",
            resource_type=MailSrBundle,
            required=True
        )

        quality_tool = sdk2.parameters.Resource(
            "Resource with tool for calc metrics",
            resource_type=resource_types.ARCADIA_PROJECT_BINARY,
            required=True
        )

    def on_execute(self):
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)
        quality_tool = sdk2.ResourceData(self.Parameters.quality_tool)
        queries = sdk2.ResourceData(self.Parameters.queries_resource)
        recommender = SmartReplyRecommender(
            self,
            str(bundle_resource_data.path),
            self.Parameters.smart_reply_server_port
        )

        quality_resource = SmartReplyQuality(self, "Smart Reply responses", "responses.json")
        quality_resource_data = sdk2.ResourceData(quality_resource)

        with open(str(quality_resource_data.path), 'w') as fout:
            sp.check_call(
                [
                    str(quality_tool.path),
                    '--source', str(queries.path),
                    '--server', 'http://localhost:{port}/msr?tvm-ku=1'.format(port=self.Parameters.smart_reply_server_port),
                    '--exps',
                ] + self.Parameters.experiments + [
                    '--no_report',
                    '--local'
                ],
                stdout=fout,
            )

        quality_resource_data.ready()
        recommender.close()
