from sandbox import sdk2

from sandbox.projects.dj.services.mail_sr.resources import MailSrBundle
from sandbox.projects.dj.services.mail_sr.resources import SmartReplyResponses
from sandbox.projects.dj.services.mail_sr.components import SmartReplyRecommender

from sandbox.projects.tank.load_resources.resources import AMMO_FILE

import sandbox.common.types.client as ctc

import StringIO
import requests


class SmartReplyGetResponses(sdk2.Task):
    """ Task for fetching Smart Reply responses """

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX
        ram = 40 * 1024
        disk_space = 70 * 1024

    class Parameters(sdk2.Task.Parameters):
        smart_reply_server_port = sdk2.parameters.Integer("Port for Smart Reply server",
                                                          default=15358,
                                                          required=True)
        request_count = sdk2.parameters.Integer("Count of requests", default=1000, required=True)

        bundle_resource = sdk2.parameters.Resource(
            "Resource with Smart Reply bundle",
            resource_type=MailSrBundle,
            required=True
        )
        queries_resource = sdk2.parameters.Resource(
            "Resource with queries",
            resource_type=AMMO_FILE,
            required=True
        )

    def parse_next_request(self, f):
        tmp = f.readline().split()
        if not tmp:
            return None
        request_size = tmp[0]

        request = f.read(int(request_size))
        f.readline()

        stream = StringIO.StringIO(request)
        first_line = stream.readline().split(' ')
        method = first_line[0]
        url = first_line[1]

        headers = {}
        while True:
            header = stream.readline()[:-2]  # \r\n
            if header == '':
                break
            key, value = header.split(':')
            headers[key] = value[1:]

        body = stream.read().strip()

        return (method, url, headers, body)

    def send_request(self, method, url, headers, body):
        full_url = "http://localhost:" + str(self.Parameters.smart_reply_server_port) + url
        return requests.request(method=method, url=full_url, headers=headers, data=body)

    def on_execute(self):
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)

        recommender = SmartReplyRecommender(self,
                                                 str(bundle_resource_data.path),
                                                 self.Parameters.smart_reply_server_port)

        queries_resource_data = sdk2.ResourceData(self.Parameters.queries_resource)

        responses_resource = SmartReplyResponses(self, "Smart Reply responses", "responses.txt")
        responses_resource_data = sdk2.ResourceData(responses_resource)

        with open(str(queries_resource_data.path), 'r') as queries_file, \
             open(str(responses_resource_data.path), 'w') as responses_file:
            for i in range(self.Parameters.request_count):
                next_request = self.parse_next_request(queries_file)
                if next_request is None:
                    continue
                method, url, headers, body = next_request
                response = self.send_request(method, url, headers, body)
                if not response.ok:
                    raise RuntimeError("Error in request processing. Url: {}. Request number: {}".format(url, i))

                responses_file.write(response.content)
                responses_file.write('\n')

        responses_resource_data.ready()

        recommender.close()
