from sandbox import sdk2
from sandbox.sandboxsdk.network import is_port_free

from sandbox.sdk2.helpers import subprocess as sp

import tarfile
import time


class SmartReplyRecommender:
    def __init__(self, task, bundle_path, port):
        with tarfile.open(bundle_path, "r:gz") as tar:
            tar.extractall()

        self.process_log = sdk2.helpers.ProcessLog(task, logger="smart_reply.log")
        self.process = sp.Popen(
            [
                "./msr_server",
                "--config", "./config.pbtxt",
                "-m", "./letter_profile.pbtxt",
                "--port", str(port),
            ],
            stdout=self.process_log.stdout, stderr=sp.STDOUT,
        )
        while is_port_free(port):
            time.sleep(1)
            if self.process.poll() is not None:
                raise RuntimeError("Error in Smart Reply server starting")

    def close(self):
        self.process.terminate()
