from sandbox import sdk2


class MailSrResourceBase(sdk2.Resource):
    releasers = [
        'plato',
        'levobuhov',
        'vvp',
    ]


class MailSrShard(MailSrResourceBase):
    """
        Mail Smart Reply index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class MailSrShardmap(MailSrResourceBase):
    """
        Mail Smart Reply index shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shardmap = True


class MailSr(MailSrResourceBase):
    """
        Mail Smart Reply service
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'dj/services/mail_sr/runtime/app'
    arcadia_build_name = 'mail_sr_service'


class MailSrBundle(MailSrResourceBase):
    """
       Bundle for mail smart reply deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SmartReplyResponses(MailSrResourceBase):
    """
        Smart Reply responses file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SmartReplyResponsesDiff(MailSrResourceBase):
    """
        Smart Reply responses diff file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SmartReplyQuality(MailSrResourceBase):
    """
        Smart Reply quality file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SmartReplyQualityQueries(MailSrResourceBase):
    """
        Smart Reply quality file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class SmartReplyQualityDiff(MailSrResourceBase):
    """
        Smart Reply quality diff file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class MailSrJugglerBundle(MailSrResourceBase):
    """
       Juggler Bundle for mail smart reply
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class MailSrBans(MailSrResourceBase):
    """
        Quick bans for Smart Reply
    """
    auto_backup = True
    releasable = True
