from sandbox import sdk2


class VhsRecommenderResourceBase(sdk2.Resource):
    releasers = [
        "robot-video-recom",
        "albus",
        "mincer",
        "shtorm941"
    ]


class VhsRecommenderShard(VhsRecommenderResourceBase):
    """
        VHS recommender index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class VhsRecommenderShardmap(VhsRecommenderResourceBase):
    """
        VHS recommender index shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shardmap = True


class VhsRecommender(VhsRecommenderResourceBase):
    """
        VHS recommender service
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'extsearch/video/recommender/runtime/app'
    arcadia_build_name = 'ether_recommender_service'


class VhsRecommenderBundle(VhsRecommenderResourceBase):

    """
       Bundle for VHS recommender deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
