from sandbox import sdk2


class VideoIzolentaResourceBase(sdk2.Resource):
    releasers = [
        "robot-video-recom",
        "palevas",
        "vvp",
    ]


class VideoIzolentaRecommenderShard(VideoIzolentaResourceBase):
    """
        Video Izolenta recommender index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class VideoIzolentaRecommenderShardmap(VideoIzolentaResourceBase):
    """
        Video Izolenta recommender index shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shardmap = True


class VideoIzolentaRecommender(VideoIzolentaResourceBase):
    """
        Video Izollenta recommender service
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'dj/services/video/runtime/app'
    arcadia_build_name = 'video_recommender_service'


class VideoIzolentaRecommenderBundle(VideoIzolentaResourceBase):
    """
       Bundle for video izolenta recommender deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
