from sandbox import sdk2


class DjRecommenderClassifiedResourceBase(sdk2.Resource):
    releasers = [
        "robot-testenv",
        "paulkovalenko",
        "vkokhtev",
        "robot-vertis-ml",
        "robot-mlmarines"
    ]


class ClassifiedDjRtyserverBin(DjRecommenderClassifiedResourceBase):
    """
        rtyserver executable
    """
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'dj/tools/saas_rty/saas_rty'
    arcadia_build_name = 'saas_rty'


class ClassifiedDjStandaloneIndexerBin(DjRecommenderClassifiedResourceBase):
    """
        standalone_indexer executable
    """
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'saas/tools/standalone_indexer/standalone_indexer'
    arcadia_build_name = 'standalone_indexer'


class ClassifiedDjShard2ResourceBundle(DjRecommenderClassifiedResourceBase):
    """
        Directory with recommender/shard_builder configs and models
    """
    releasable = True
    executable = False


class ClassifiedDjShard2Models(DjRecommenderClassifiedResourceBase):
    """
        Directory with models
    """
    releasable = True
    executable = False


class ClassifiedDjMiddleModels(DjRecommenderClassifiedResourceBase):
    """
    tar gz with models
    """
    releasable = True
    executable = False


class ClassifiedDjMiddleConfig(DjRecommenderClassifiedResourceBase):
    """
    meta recommender config
    """
    releasable = True
    executable = False


class ClassifiedDjOfferFastIndex(DjRecommenderClassifiedResourceBase):
    """
    meta recommender config
    """
    releasable = True
    executable = False
