from sandbox import sdk2


class DjRecommenderEcomResourceBase(sdk2.Resource):
    releasers = [
        "dpaveldev",
        "rudolf",
        "kcd",
        "robot-testenv",
        "paulkovalenko",
        "robot-adv-machine",
        "robot-collections",
        "robot-mlmarines"
    ]


class EcomDjRtyserverBin(DjRecommenderEcomResourceBase):
    """
        rtyserver executable
    """
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'dj/tools/saas_rty/saas_rty'
    arcadia_build_name = 'saas_rty'


class EcomDjStandaloneIndexerBin(DjRecommenderEcomResourceBase):
    """
        standalone_indexer executable
    """
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'saas/tools/standalone_indexer/standalone_indexer'
    arcadia_build_name = 'standalone_indexer'


class EcomDjShard2ResourceBundle(DjRecommenderEcomResourceBase):
    """
        Directory with recommender/shard_builder configs and models
    """
    releasable = True
    executable = False


class EcomDjShard2Models(DjRecommenderEcomResourceBase):
    """
        Directory with models
    """
    releasable = True
    executable = False


class EcomDjMiddleModels(DjRecommenderEcomResourceBase):
    """
    tar gz with models
    """
    releasable = True
    executable = False


class EcomDjMiddleConfig(DjRecommenderEcomResourceBase):
    """
    meta recommender config
    """
    releasable = True
    executable = False
