from sandbox import sdk2


class DjRecommenderGoodsResourceBase(sdk2.Resource):
    releasers = [
        "mincer",
        "vpp",
        "dskor",
        "GOODS_RECOMMENDER",
        "robot-mlp-morpheus",
        "robot-srch-releaser",
    ]


class GoodsDjRtyserverBin(DjRecommenderGoodsResourceBase):
    """
        rtyserver executable
    """
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'dj/tools/saas_rty/saas_rty'
    arcadia_build_name = 'saas_rty'


class GoodsDjMiddleSearchBin(DjRecommenderGoodsResourceBase):
    """
        middlesearch executable
    """
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'dj/tools/middlesearch/middlesearch'
    arcadia_build_name = 'middlesearch'


class GoodsDjStandaloneIndexerBin(DjRecommenderGoodsResourceBase):
    """
        standalone_indexer executable
    """
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'saas/tools/standalone_indexer/standalone_indexer'
    arcadia_build_name = 'standalone_indexer'


class GoodsDjShard2ResourceBundle(DjRecommenderGoodsResourceBase):
    """
        Directory with recommender/shard_builder configs and models
    """
    releasable = True
    executable = False
    ttl = 360


class GoodsDjShard2Models(DjRecommenderGoodsResourceBase):
    """
        Directory with models
    """
    releasable = True
    executable = False


class GoodsDjShard2MiddleSearchResourceBundle(DjRecommenderGoodsResourceBase):
    """
        Directory with recommender configs and models
    """
    releasable = True
    executable = False
    ttl = 360

class GoodsDjShard2MiddleSearchConfigPrestable(DjRecommenderGoodsResourceBase):
    """
        middlesearch.cfg for prestable
    """
    releasable = True
    executable = False
    ttl = 360

class GoodsDjShard2MiddleSearchConfigStable(DjRecommenderGoodsResourceBase):
    """
        middlesearch.cfg for stable
    """
    releasable = True
    executable = False
    ttl = 360

class GoodsDjShard2MiddleEvlogdump(DjRecommenderGoodsResourceBase):
    """
        middlesearch.cfg for stable
    """
    releasable = True
    executable = False
    ttl = 360
