from sandbox import sdk2


class DjRecommenderMarketResourceBase(sdk2.Resource):
    releasers = [
        "kcd",
        "robot-testenv",
        "paulkovalenko",
        "mikbar",
        "robot-collections",
        "robot-mlmarines"
    ]


class MarketDjRtyserverBin(DjRecommenderMarketResourceBase):
    """
        rtyserver executable
    """
    releasable = True
    executable = True


class MarketDjShard2ResourceBundle(DjRecommenderMarketResourceBase):
    """
        Directory with recommender/shard_builder configs and models
    """
    releasable = True
    executable = False


class MarketDjShard2Models(DjRecommenderMarketResourceBase):
    """
        Directory with models
    """
    releasable = True
    executable = False
