from sandbox import sdk2


class DjRecommenderPdbBoardResourceBase(sdk2.Resource):
    releasers = [
        "kcd",
        "robot-testenv",
        "paulkovalenko",
        "alexbudanov",
        "volodskikh",
        "jisuto",
        "v01d",
        "cvzakhar",
        "spkhaykova",
        "mikbar",
        "robot-collections"
    ]


class PdbBoardDjRtyserverBin(DjRecommenderPdbBoardResourceBase):
    """
        rtyserver executable
    """
    releasable = True
    executable = True


class PdbBoardDjShard2ResourceBundle(DjRecommenderPdbBoardResourceBase):
    """
        Directory with recommender/shard_builder configs and models
    """
    releasable = True
    executable = False


class PdbBoardDjShard2Models(DjRecommenderPdbBoardResourceBase):
    """
        Directory with models
    """
    releasable = True
    executable = False
