from sandbox import sdk2


class DjRecommenderShinyDiscoveryResourceBase(sdk2.Resource):
    releasers = [
        "atsky",
        "kcd"
    ]


class ShinyDiscoveryDjRtyserverBin(DjRecommenderShinyDiscoveryResourceBase):
    """
        rtyserver executable
    """
    releasable = True
    executable = True


class ShinyDiscoveryDjShard2ResourceBundle(DjRecommenderShinyDiscoveryResourceBase):
    """
        Directory with recommender/shard_builder configs and models
    """
    releasable = True
    executable = False

class ShinyDiscoveryDjShard2Models(DjRecommenderShinyDiscoveryResourceBase):
    """
        Directory with models
    """
    releasable = True
    executable = False

class ShinyDiscoveryModelsBundle(DjRecommenderShinyDiscoveryResourceBase):
    """
        Directory with models (except min_hash)
    """
    releasable = False
    executable = False

class ShinyDiscoveryMinHash(DjRecommenderShinyDiscoveryResourceBase):
    """
        Directory with models (except min_hash)
    """
    releasable = False
    executable = False
