from sandbox import sdk2


class DjRecommenderVhsResourceBase(sdk2.Resource):
    releasers = [
        "aykeron",
        "mincer",
        "kcd",
        "VIDEODEV",
        "VIDEORECOM",
        "robot-video-recom",
        "robot-srch-releaser",
        "paulkovalenko",
    ]


class VhsDjRtyserverBin(DjRecommenderVhsResourceBase):
    """
        rtyserver executable
    """
    releasable = True
    executable = True


class VhsDjShard2ResourceBundle(DjRecommenderVhsResourceBase):
    """
        Directory with recommender/shard_builder configs and models
    """
    releasable = True
    executable = False
    ttl = 360

class Doc2docDjShard2ResourceBundle(DjRecommenderVhsResourceBase):
    """
        Directory with recommender/shard_builder configs and models
    """
    releasable = True
    executable = False
    ttl = 360


class VhsDjShard2Models(DjRecommenderVhsResourceBase):
    """
        Directory with models
    """
    releasable = True
    executable = False


class VhsConfigResolverBin(DjRecommenderVhsResourceBase):
    """
        config_resolver executable
    """
    releasable = True
    executable = True


class VhsConfigResolverBundle(DjRecommenderVhsResourceBase):
    """
        config_resolver bundle
    """
    releasable = True
    executable = False
