from sandbox import sdk2


class DjRecommenderZaasResourceBase(sdk2.Resource):
    releasers = [
        "grievous",
        "gaiduk",
        "comunodi",
        "zsvianadze"
    ]


class ZaasDjRtyserverBin(DjRecommenderZaasResourceBase):
    """
        rtyserver executable
    """
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'dj/tools/saas_rty/saas_rty'
    arcadia_build_name = 'saas_rty'


class ZaasDjStandaloneIndexerBin(DjRecommenderZaasResourceBase):
    """
        standalone_indexer executable
    """
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'saas/tools/standalone_indexer/standalone_indexer'
    arcadia_build_name = 'standalone_indexer'


class ZaasDjShard2ResourceBundle(DjRecommenderZaasResourceBase):
    """
        Directory with recommender/shard_builder configs and models
    """
    releasable = True
    executable = False


class ZaasDjShard2Models(DjRecommenderZaasResourceBase):
    """
        Directory with models
    """
    releasable = True
    executable = False


class ZaasDjMiddleModels(DjRecommenderZaasResourceBase):
    """
    tar gz with models
    """
    releasable = True
    executable = False


class ZaasDjMiddleConfig(DjRecommenderZaasResourceBase):
    """
    meta recommender config
    """
    releasable = True
    executable = False
