from sandbox import sdk2


dj_unity_releasers = [
    "volodskikh",
    "kcd",
    "v01d",
    "jisuto",
    "eugeninic",
    "dpaveldev",
    "nomapunk",
    "kirkov-andrey",
    "ekondranin",
    "xveduk",
    "rudolf",
    "robot-testenv",
    "robot-srch-releaser",
]


class DjUnityPackage(sdk2.Resource):
    """
    DJ Unity package
    """

    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = dj_unity_releasers


class DjUnityProfileReaderPackage(sdk2.Resource):
    """
    DJ Unity Profile Reader package
    """

    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = dj_unity_releasers


class DjUnityHostIdf(sdk2.Resource):
    """
    DJ Unity Host IDF values in trie
    """

    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = dj_unity_releasers


class DjUnityWordIdf(sdk2.Resource):
    """
    DJ Unity Word IDF values in trie
    """

    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = dj_unity_releasers


class DjUnityOntoObjectIdf(sdk2.Resource):
    """
    DJ Unity Onto-Object IDF values in trie
    """

    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = dj_unity_releasers
