import json
import requests
import urlparse


class HitmanClient(object):
    def __init__(self, token):
        self.token = token
        self.url = 'https://hitman.yandex-team.ru'
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(self.token)
        self.session.headers['Content-Type'] = 'application/json'

    def start_process(self, process_id, requester, properties, job_token=None, comment=None):
        url = urlparse.urljoin(self.url, '/api/v1/execution/start/{}'.format(process_id))
        data = {'requester': requester, 'comment': comment, 'properties': properties}
        params = {'token': job_token} if job_token else {}
        return self.request('post', url, params, data=json.dumps(data))

    def update_workflow_id(self, process_id, workflowId):
        url = urlparse.urljoin(self.url, '/api/v1/process/{}'.format(process_id))
        params = {'workflow-id': workflowId}
        return self.request('put', url, params)

    def request(self, method, path, params=None, data=None):
        response = self.session.request(method, path, params=params, data=data, verify=False)
        response.raise_for_status()
        return response.json() if response.text else None
