# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.douber import releasers as dreleasers


class DouberResource(sdk2.Resource):
    releasable = True
    releasers = dreleasers.douber_releasers
    release_subscribers = dreleasers.douber_releasers
    ttl = 30


class DouberBinary(DouberResource):
    """
        Douber binary.
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'douber/backend/bin/douber'


class DouberManageBinary(DouberResource):
    """
        Douber manage binary.
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'douber/backend/manage_bin/manage'


class DouberConfig(DouberResource):
    """
        Douber configuration archive.
    """


class DouberManageConfig(DouberResource):
    """
        Douber manage configuration archive.
    """


class DouberAppHostServiceBinary(DouberResource):
    """
        Douber AppHost service binary.
    """
    any_arch = False
    executable = True
    arcadia_build_path = 'douber/apphost_service/douber-apphost-service'


class DouberAppHostServiceConfig(DouberResource):
    """
        Douber AppHost service configuration archive.
    """


class DouberSettingsJson(DouberResource):
    """
        Douber settings json file
    """
    arcadia_build_path = 'douber/common/resources'


__all__ = [
    'DouberBinary',
    'DouberManageBinary',
    'DouberConfig',
    'DouberManageConfig',
    'DouberAppHostServiceBinary',
    'DouberAppHostServiceConfig',
    'DouberSettingsJson',
]
