# -*- coding: utf-8 -*-

from sandbox.projects.common.build.YaMake2 import YaMake2
from sandbox.projects.drive import (
    DriveAnalyticsServerBinary,
    DriveAnalyticsServerTestingApiConfig,
    DriveAnalyticsServerTestingWorkerConfig,
    DriveAnalyticsServerPrestableApiConfig,
    DriveAnalyticsServerPrestableWorkerConfig,
    DriveAnalyticsServerProductionApiConfig,
    DriveAnalyticsServerProductionWorkerConfig
)


class BuildDriveAnalyticsServer(YaMake2):
    def get_targets(self):
        return (
            "drive/analytics/binary/server",
        )

    def get_arts(self):
        return [
            {"path": "drive/analytics/binary/server/server"},
            {"path": "drive/analytics/binary/server/deploy/testing-api-config.json"},
            {"path": "drive/analytics/binary/server/deploy/testing-worker-config.json"},
            {"path": "drive/analytics/binary/server/deploy/prestable-api-config.json"},
            {"path": "drive/analytics/binary/server/deploy/prestable-worker-config.json"},
            {"path": "drive/analytics/binary/server/deploy/production-api-config.json"},
            {"path": "drive/analytics/binary/server/deploy/production-worker-config.json"},
        ]

    def get_resources(self):
        return {
            DriveAnalyticsServerBinary.name: {
                "resource_path": "server",
                "resource_type": DriveAnalyticsServerBinary,
                "description": DriveAnalyticsServerBinary.name,
            },
            DriveAnalyticsServerTestingApiConfig.name: {
                "resource_path": "testing-api-config.json",
                "resource_type": DriveAnalyticsServerTestingApiConfig,
                "description": DriveAnalyticsServerTestingApiConfig.name,
            },
            DriveAnalyticsServerTestingWorkerConfig.name: {
                "resource_path": "testing-worker-config.json",
                "resource_type": DriveAnalyticsServerTestingWorkerConfig,
                "description": DriveAnalyticsServerTestingWorkerConfig.name,
            },
            DriveAnalyticsServerPrestableApiConfig.name: {
                "resource_path": "prestable-api-config.json",
                "resource_type": DriveAnalyticsServerPrestableApiConfig,
                "description": DriveAnalyticsServerPrestableApiConfig.name,
            },
            DriveAnalyticsServerPrestableWorkerConfig.name: {
                "resource_path": "prestable-worker-config.json",
                "resource_type": DriveAnalyticsServerPrestableWorkerConfig,
                "description": DriveAnalyticsServerPrestableWorkerConfig.name,
            },
            DriveAnalyticsServerProductionApiConfig.name: {
                "resource_path": "production-api-config.json",
                "resource_type": DriveAnalyticsServerProductionApiConfig,
                "description": DriveAnalyticsServerProductionApiConfig.name,
            },
            DriveAnalyticsServerProductionWorkerConfig.name: {
                "resource_path": "production-worker-config.json",
                "resource_type": DriveAnalyticsServerProductionWorkerConfig,
                "description": DriveAnalyticsServerProductionWorkerConfig.name,
            },
        }
