# -*- coding: utf-8 -*-

from sandbox.projects.common.build.YaMake2 import YaMake2
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToYaDeployTask2
from sandbox.projects.drive import (
    DriveRunnerBinary,
    DriveRunnerTestingServerConfig,
    DriveRunnerTestingWorkerConfig,
    DriveRunnerPrestableServerConfig,
    DriveRunnerPrestableWorkerConfig,
    DriveRunnerProductionServerConfig,
    DriveRunnerProductionWorkerConfig
)


class DriveRunnerDeploy(ReleaseToYaDeployTask2, YaMake2):
    def get_targets(self):
        return (
            "drive/runner",
        )

    def get_arts(self):
        return [
            {"path": "drive/runner/runner"},
            {"path": "drive/runner/deploy/testing-server-config.json"},
            {"path": "drive/runner/deploy/testing-worker-config.json"},
            {"path": "drive/runner/deploy/prestable-server-config.json"},
            {"path": "drive/runner/deploy/prestable-worker-config.json"},
            {"path": "drive/runner/deploy/production-server-config.json"},
            {"path": "drive/runner/deploy/production-worker-config.json"},
        ]

    def get_resources(self):
        return {
            DriveRunnerBinary.name: {
                "resource_path": "runner",
                "resource_type": DriveRunnerBinary,
                "description": DriveRunnerBinary.name,
            },
            DriveRunnerTestingServerConfig.name: {
                "resource_path": "testing-server-config.json",
                "resource_type": DriveRunnerTestingServerConfig,
                "description": DriveRunnerTestingServerConfig.name,
            },
            DriveRunnerTestingWorkerConfig.name: {
                "resource_path": "testing-worker-config.json",
                "resource_type": DriveRunnerTestingWorkerConfig,
                "description": DriveRunnerTestingWorkerConfig.name,
            },
            DriveRunnerPrestableServerConfig.name: {
                "resource_path": "prestable-server-config.json",
                "resource_type": DriveRunnerPrestableServerConfig,
                "description": DriveRunnerPrestableServerConfig.name,
            },
            DriveRunnerPrestableWorkerConfig.name: {
                "resource_path": "prestable-worker-config.json",
                "resource_type": DriveRunnerPrestableWorkerConfig,
                "description": DriveRunnerPrestableWorkerConfig.name,
            },
            DriveRunnerProductionServerConfig.name: {
                "resource_path": "production-server-config.json",
                "resource_type": DriveRunnerProductionServerConfig,
                "description": DriveRunnerProductionServerConfig.name,
            },
            DriveRunnerProductionWorkerConfig.name: {
                "resource_path": "production-worker-config.json",
                "resource_type": DriveRunnerProductionWorkerConfig,
                "description": DriveRunnerProductionWorkerConfig.name,
            },
        }
