import logging
import os

import sandbox.common.errors as sb_err
import sandbox.common.types.resource as ctr
from sandbox import sdk2

import sandbox.projects.common.dynamic_models.bundles as models_bundles
import sandbox.projects.common.dynamic_models.const as models_const
import sandbox.projects.common.dynamic_models.matrixnet as models_mxnet
from sandbox.projects import resource_types


class CheckIndependentInfoFormulas(sdk2.Task):
    """
        Finds .info models which are not stated in .json
    """
    class Requirements(sdk2.Requirements):
        disk_space = 25 * 1024  # 25 Gb
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 30 * 60  # 30 min

    def on_execute(self):
        root_path = sdk2.svn.Arcadia.export(models_const.MODELS_EXPERIMENT_URL, "models")
        all_formulas_in_json = set([])
        paths_to_check = [root_path]
        for _, bundle_cfg in models_bundles.get_bundles_info(paths_to_check, short_path=False, recursive=False):
            all_formulas_in_json.update(set(models_bundles.bundle_formula_ids(bundle_cfg[0])))
        all_info_formulas = models_mxnet.get_models_id(self._get_mx_ops_path(), paths_to_check, recursive=False)
        not_in_json = set([])
        for info_formula in all_info_formulas:
            formula_path, formula_id = info_formula
            if formula_id not in all_formulas_in_json:
                not_in_json.add(info_formula)
                logging.info("%s with id %s not in json!", os.path.relpath(formula_path), formula_id)
        if not_in_json:  # SEARCH-6959
            raise sb_err.TaskFailure("There are some .info models without json: {}".format(not_in_json))

    @staticmethod
    def _get_mx_ops_path():
        mx_ops = list(sdk2.Resource.find(
            resource_type=resource_types.MX_OPS_EXECUTABLE,
            state=ctr.State.READY,
        ).limit(1))[0]
        logging.info("Mx ops resource found: %s", mx_ops)
        return str(sdk2.ResourceData(mx_ops).path)
