import logging

logger = logging.getLogger(__name__)


class AllureTestcaseLink:
    def __init__(self, name, type_link):
        self._name = name
        self._type_link = type_link

    @property
    def name(self):
        return self._name

    @property
    def type_link(self):
        return self._type_link

    @staticmethod
    def _validate_dict(d):
        try:
            assert (
                'name' in d
            ), '\'name\' should be exist in Allure Testcase object'
            assert (
                'type' in d
            ), '\'type\' should be exist in Allure Testcase object'
            assert isinstance('name', str), '\'name\' should be string'
            assert isinstance('type', str), '\'type\' should be string'
        except AssertionError as e:
            logger.error(e)
            raise e

    @classmethod
    def from_dict(cls, d):
        AllureTestcaseLink._validate_dict(d)
        return cls(name=d['name'], type_link=d['type'])


class AllureTestcase:
    def __init__(self, name, status, links):
        self._name = name
        self._status = status
        self._links = links

    @property
    def name(self):
        return self._name

    @property
    def status(self):
        return self._status

    @property
    def links(self):
        return self._links

    @staticmethod
    def _validate_dict(d):
        try:
            assert (
                'name' in d
            ), '\'name\' should be exist in Allure Testcase object'
            assert (
                'status' in d
            ), '\'status\' should be exist in Allure Testcase object'
            assert (
                'links' in d
            ), '\'links\' should be exist in Allure Testcase object'
            assert isinstance(d['name'], unicode), '\'name\' should be string'
            assert isinstance(d['status'], unicode), '\'status\' should be string'
            assert isinstance(d['links'], list), '\'links\' should be list'
        except AssertionError as e:
            logger.error(e)
            raise e

    @classmethod
    def from_dict(cls, d):
        AllureTestcase._validate_dict(d)
        links = []
        for link in d['links']:
            links.append(AllureTestcaseLink.from_dict(link))
        return cls(name=d['name'], status=d['status'], links=links)
