import json
import logging
import os

from sandbox.projects.eats.EatsCreateTestpalmRun.allure.allure_objects import AllureTestcase

logger = logging.getLogger(__name__)


class AllureParser:
    def __init__(self, directory):
        self.directory = directory

    @staticmethod
    def _get_testpalm_id(testcase):
        for link in testcase.links:
            if link.type_link == 'tms' and link.name.isnumeric():
                return int(link.name)
            logger.warning('testpalm_id not found in testcase: %s', testcase)

    def _parse_allure(self):
        allure = []
        for filename in os.listdir(self.directory):
            f = os.path.join(self.directory, filename)
            if os.path.isfile(f):
                with open(f) as json_file:
                    testcase = json.load(json_file)
                allure.append(AllureTestcase.from_dict(testcase))
        return allure

    def prepare_data(self):
        allure_testcases = self._parse_allure()
        statuses = {}
        for allure_testcase in allure_testcases:
            testcase_id = self._get_testpalm_id(allure_testcase)
            if testcase_id:
                if (
                        allure_testcase.status == 'passed'
                        and testcase_id not in statuses
                ):
                    statuses[testcase_id] = 'PASSED'
                elif allure_testcase.status != 'passed':
                    statuses[testcase_id] = 'FAILED'
        return statuses
