# coding=utf-8

import logging

from typing import Tuple, Union

from sandbox import sdk2
from startrek_client import Startrek
from yt.wrapper import YtClient
from yql.api.v1.client import YqlClient

from .main import main
from .utils import prepare_date


class ComputeSpStatistic(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        secret = sdk2.parameters.YavSecret(
            'Secret in Vault:',
            required=True,
            default='sec-01g3x0t1hc5arnjr6qzvhg038h',
        )
        command_name: str = sdk2.parameters.String(
            'Name of the command to analyze:',
            description="""Название команды для анализа (ключ в конфиге)""",
        )
        start_date: str = sdk2.parameters.String(
            'Start date:',
            description='Дата начала анализа в формате : YYYY-MM-DD',
        )

    def on_execute(self):

        oauth_token: str = self.Parameters.secret.data()['oauth'].strip()
        token_yt: str = self.Parameters.secret.data()['chyt_token'].strip()
        token_yql: str = self.Parameters.secret.data()['yql_token'].strip()
        start_date: Union[None, Tuple[int, int, int]] = prepare_date(
            self.Parameters.start_date.strip(),
        )
        command_name: str = self.Parameters.command_name.strip()

        client_yt = YtClient(proxy='hahn', token=token_yt)
        client_startrek = Startrek(
            useragent='robot-pmo-automation', token=oauth_token,
        )
        client_yql = YqlClient(db='hahn', token=token_yql)
        if (
                start_date is None
                and command_name
                or start_date
                and not command_name
        ):
            raise ValueError(
                'Please input both or delete both values "command_name" and '
                '"start_date"',
            )
        elif start_date and command_name:
            analyzed_team = {command_name: start_date}
            logging.info(
                f"""The statistics of {command_name} team will be computed
with start at {start_date}.""",
            )
        else:
            analyzed_team = None
            logging.info('The statistics of all teams will be computed.')

        main(client_yt, client_startrek, client_yql, analyzed_team)
