# dict transformation Sp into interval of hours
default_sp_to_hours = {
    1: [0, 2],  # 1Sp is interval 0-2 hours
    2: [2, 4],
    3: [4, 8],
    5: [8, 16],
}

# Config for statistic:
# Add in dict 'teams' key - name team (it value will be the name in datalens).
# Value for team name consist:
#   1. 'Query' - (str) valid query for startrek for getting tickets (required)
#   2. 'sp_is_hour' - (bool) is using sp as hours (required)
#   3. 'intervals' - (dict) empty dict if 'sp_is_hour' is True else use
#     'default_sp_to_hours' or make similar with new values (required)
#   4. 'filters' filters for dataframe (naming of columns dataframe in
#     'startrek_data.py'). Dict of key - name column and value - list
#     of acceptable values (not required)

teams = {
    'EDACOMMON-1': {
        'query': 'Queue: EDACOMMON AND "Components": СС_Group1',
        'sp_is_hour': False,
        'intervals': default_sp_to_hours,
        'filters': {
            'assignee_login': [
                'm-mikhailov',
                'klestoff',
                'dfedyaev',
                'p34k1n',
                'ulasob',
            ],
        },
        # 'acceptable tags': ['python'],  # can set only acceptable
        'invalid tags': ['common-planning'],  # skipped tags
    },
    'EDACOMMON-2': {
        'query': 'Queue: EDACOMMON AND "Components": СС_Group2',
        'sp_is_hour': False,
        'intervals': default_sp_to_hours,
        'filters': {
            'assignee_login': ['tabota', 'airmyxa', 'tarasalk', 'etchulkov'],
        },
    },
    'OPG-BILLING': {
        'query': 'Queue: EDAORDERS',
        'sp_is_hour': True,
        'intervals': {},
        'filters': {
            'assignee_login': [
                'abarchukova',
                'beresnev-s',
                'werewind',
                'dmtr-nuzhdin',
                'alextrust',
            ],
        },
    },
    'PROCESSING': {
        'query': 'Queue: EDAORDERS',
        'sp_is_hour': True,
        'intervals': {},
        'filters': {'assignee_login': ['pivchenberg', 'tvir', 'vshept']},
    },
    'EDABILLING': {
        'query': 'Queue: EDABILLING',
        'sp_is_hour': True,
        'intervals': {},
    },
    'RestIQ': {
        'query': 'Queue: EDAPARTNERS AND "Components": RestIQ',
        'sp_is_hour': False,
        'intervals': {
            1: [0, 4],
            2: [2, 4],
            3: [8, 16],
            5: [16, 30],
            8: [20, 36],
            13: [30, 48],
        },
    },
    'RestEnjoy': {
        'query': 'Queue: EDAPARTNERS AND "Components": RestEnjoy',
        'sp_is_hour': False,
        'intervals': {
            1: [0, 4],
            2: [2, 4],
            3: [8, 16],
            5: [16, 30],
            8: [20, 36],
            13: [30, 48],
        },
    },
    'TeamChe1': {
        'query': 'Queue: EDADEV AND "Components": TeamChe',
        'sp_is_hour': False,
        'intervals': {
            0.5: [0, 1],
            1: [0, 2],
            2: [2, 5],
            3: [4, 10],
            5: [10, 16],
            8: [16, 32],
        },
    },
    'Team Eaters': {
        'query': 'Queue: EDAEATERS',
        'sp_is_hour': True,
        'intervals': {},
    },
    'Eats Android': {
        'query': 'Queue: EDAFRONT AND Components: AndroidClient',
        'sp_is_hour': True,
        'intervals': {},
        'key_to_estimated_time': 'storyPoints',
        'key_to_spent_time': 'spentSp',
    },
    'Eats IOS': {
        'query': 'Queue: EDAFRONT AND Components: iOSClient',
        'sp_is_hour': True,
        'intervals': {},
        'key_to_estimated_time': 'storyPoints',
        'key_to_spent_time': 'spentSp',
    },
    'Retail Web': {
        'query': 'Queue: EDAWWW AND tags: retail',
        'sp_is_hour': True,
        'intervals': {},
        'key_to_estimated_time': 'storyPoints',
        'key_to_spent_time': 'spentSp',
    },
    'Retail UX': {
        'query': 'Queue: RETAILDEV OR RETAILUX"',
        'sp_is_hour': True,
        'intervals': {},
    },
    'Retail Platform': {
        'query': 'Queue: EDAPLATFORM',
        'sp_is_hour': False,
        'intervals': {
            1: [0, 2],
            2: [2, 4],
            3: [4, 8],
            5: [8, 16],
            8: [16, 24],
        },
    },
    'Team Automation': {
        'query': 'Queue: EDAAUTO',
        'sp_is_hour': False,
        'intervals': default_sp_to_hours,
    },
    'EDAOPS': {
        'query': 'Queue: EDAOPS',
        'sp_is_hour': False,
        'intervals': default_sp_to_hours,
    },
}
