# coding=utf-8

import logging


def check_success(request):
    if request.is_success:
        logging.info('Request is successful!')
    else:
        logging.error('Request is %s.' % request.status)
        if request.errors:
            logging.error('Returned errors:')
            for error in request.errors:
                logging.error(' - ' + str(error))
        raise Exception('YQL request unsuccessful, see logs above')


def remove_duplicates(yql_client, table, columns):
    query_template = """\
PRAGMA yt.TmpFolder = "//home/eda/statistics/tmp";
INSERT INTO hahn.`{0}` WITH TRUNCATE
SELECT
    `Key`,
{1}
FROM (
    SELECT
        LIST_SORT_DESC(AGGREGATE_LIST(`Data`), ($x) -> {{
        RETURN $x.`ResolutionTime`;}})[0] As `Data`, `Key`
    FROM (
    SELECT
        AsStruct(
{2}
        ) As `Data`,
        `Key`,
    FROM hahn.`{0}`
    )
    GROUP BY `Key`
);
"""

    columns_to_struct_template = '\t\t\t`{0}` AS `{0}`,'
    struct_to_columns_template = '\t`Data`.`{0}` AS `{0}`,'

    columns_to_struct = '\n'.join(
        [columns_to_struct_template.format(column) for column in columns],
    )
    struct_to_columns = '\n'.join(
        [struct_to_columns_template.format(column) for column in columns],
    )

    query = query_template.format(table, struct_to_columns, columns_to_struct)
    logging.info('Running query: ' + query)

    request = yql_client.query(query, syntax_version=1)
    request.run()
    results = request.get_results()
    check_success(results)
