# coding=utf-8

import logging

from sandbox import sdk2

from .uml import EXPECTED, json_to_uml

import requests

import json


class GetDataMappingsSettings(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        secret = sdk2.parameters.YavSecret(
            'Wiki token:',
            required=True,
            default='sec-01g274d0k80ywat8pkab143aq3',
        )
        page_slug = sdk2.parameters.String(
            'Page slug to write:',
            description="""Адрес страницы для записи""",
            required=True,
        )
        debug = sdk2.parameters.Bool(
            'Use debug data instead of getting it from the handle:',
            default=False,
        )
        testing = sdk2.parameters.Bool(
            'Use testing handle instead of prod handle:', default=False,
        )

    text_template = """\
Данная страница геренируется автоматически, не редактируйте!
{0}

===+ Как обновить данные

{{{{include href="/eda/team/backend/platformteams/cc/eats-data-mappings/settings-visualization/" notoc nomark notitle}}}}

===Чтение===
{1}

===Запись===
{2}\
"""

    wiki_api_url = 'https://wiki-api.yandex-team.ru/'
    page_data_url = wiki_api_url + 'api/v2/public/pages?slug={0}'
    update_page_url = wiki_api_url + 'api/v2/public/pages/{0}'

    def on_execute(self):

        wiki_token = self.Parameters.secret.data()['token'].strip()
        page_slug = self.Parameters.page_slug.strip()
        debug = self.Parameters.debug
        testing = self.Parameters.testing

        if debug:
            data = EXPECTED
            status = 'Отображены дебаг-настройки.'
        elif testing:
            data = requests.get(
                'eats-data-mappings.eda.tst.yandex.net/service/v1/settings',
            ).json()
            status = 'Отображены настройки тестингового сервиса.'
        else:
            data = requests.get(
                'eats-data-mappings.eda.yandex.net/service/v1/settings',
            ).json()
            status = 'Отображены настройки продового сервиса.'

        text = self.text_template.format(
            status,
            json_to_uml(data, 'tvm_read'),
            json_to_uml(data, 'tvm_write'),
        )

        r = requests.get(
            self.page_data_url.format(page_slug),
            headers={'Authorization': 'OAuth ' + wiki_token},
            data={'fields': 'id'},
        )
        logging.log(logging.DEBUG, json.dumps(r.json()))
        id = r.json()['id']
        r = requests.post(
            self.update_page_url.format(str(id)),
            headers={
                'Authorization': 'OAuth ' + wiki_token,
                'Content-Type': 'application/json',
            },
            json={'content': text},
        )
        logging.log(logging.DEBUG, json.dumps(r.json()))
