EXPECTED = {
    'entities': {'some1', 'some2', 'some3', 'some4'},
    'entity_mappings': [
        {
            'first_entity_type': 'some1',
            'second_entity_type': 'some2',
            'tvm_write': {'service1'},
            'tvm_read': {'service1', 'service2'},
        },
        {
            'first_entity_type': 'some2',
            'second_entity_type': 'some3',
            'tvm_write': {'service2'},
            'tvm_read': {'service2', 'service3'},
        },
        {
            'first_entity_type': 'some2',
            'second_entity_type': 'some4',
            'tvm_write': {'service1', 'service2', 'service3'},
            'tvm_read': {'service1', 'service2', 'service3', 'service4'},
        },
    ],
}

fulluml_template = """\
%%(plantuml)
@startuml

{0}

{1}

@enduml
%%\
"""

entity_template = '({0})'

mapping_template = '{0} == {1}: **{2}**'


def json_to_uml(data, mode):
    entity_txt = '\n'.join(
        [entity_template.format(entity) for entity in data['entities']],
    )
    mapping_txt = '\n'.join(
        [
            mapping_template.format(
                mapping['first_entity_type'],
                mapping['second_entity_type'],
                ', '.join(mapping[mode]),
            )
            for mapping in data['entity_mappings']
        ],
    )
    return fulluml_template.format(entity_txt, mapping_txt)
