# coding=utf-8

from sandbox import sdk2


class LinkDutyTask(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        secret = sdk2.parameters.YavSecret(
            "Secret:",
            required=True,
            default='sec-01fntehbvnfjzy9mkhrf85n4xa'
        )
        query = sdk2.parameters.String(
            "Query:",
            required=True,
            description="""Запрос к трекеру(ожидается, что задачи
соответствующие запросу относятся к очереди EDADUTY)"""
        )
        queue_dev_tickets = sdk2.parameters.List(
            "List of queue for develop tickets:",
            required=True,
            description="""Список очередей, в которых будут исправлены баги"""
        )
        type_dev_tickets = sdk2.parameters.List(
            "Type of develop tickets:",
            required=True,
            description="Типы тикетов, в которых будут исправлены баги"
        )
        field = sdk2.parameters.String(
            "Field for count bug reports:",
            required=True,
            description="""Список очередей, в которых будут исправлены баги"""
        )

    def on_execute(self):
        from builtins import unicode

        from .models import CounterLinks
        from .startrek_client import Startrek

        def prepare_string(string):
            string = (
                string.encoding('utf')
                if string is isinstance(string, unicode)
                else string
            )
            return string.strip()

        oauth_token = prepare_string(
            self.Parameters.secret.data()['oauth'].strip()
        )
        query = prepare_string(self.Parameters.query)
        queues_dev_tickets = [
            prepare_string(x) for x in self.Parameters.queue_dev_tickets
        ]
        types_dev_tickets = [
            prepare_string(x) for x in self.Parameters.type_dev_tickets
        ]
        field = prepare_string(self.Parameters.field)

        st_client = Startrek(oauth_token)

        counter_tasks = CounterLinks(
            st_client, types_dev_tickets, queues_dev_tickets, field
        )
        counter_tasks.count_and_write_links(query)
