# coding=utf-8

from sandbox import sdk2
import sandbox.projects.common.environments as env


class UpdaterPriority(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [env.PipEnvironment("jmespath")]

    class Parameters(sdk2.Task.Parameters):
        oauth = sdk2.parameters.YavSecret(
            "OAuth token:",
            required=True,
            default='sec-01fntehbvnfjzy9mkhrf85n4xa'
        )
        trivial = sdk2.parameters.String(
            "Interval weights for trivial:",
            required=True,
            default="0 19",
            description="Нужно задать два числа разделенных пробелом"
        )
        minor = sdk2.parameters.String(
            "Interval weights for minor:",
            required=True,
            default="20 39",
            description="Нужно задать два числа разделенных пробелом"
        )
        normal = sdk2.parameters.String(
            "Interval weights for normal:",
            required=True,
            default="40 59",
            description="Нужно задать два числа разделенных пробелом"
        )
        critical = sdk2.parameters.String(
            "Interval weights for critical:",
            required=True,
            default="60 79",
            description="Нужно задать два числа разделенных пробелом"
        )
        blocker = sdk2.parameters.String(
            "Interval weights for blocker:",
            required=True,
            default="80 inf",
            description='Нужно задать два числа разделенных пробелом, inf - бесконечность'
        )
        query = sdk2.parameters.String(
            "Query for startrek:",
            default='Key: EDACOMMON-1580',
            description="""Для изменения приоритетов нужно задать либо
        запрос, либо список задач(следующее поле). При наличии запроса и списка
         будут изменены только таски из запроса (Приоритет запроса выше)"""
        )
        formula = sdk2.parameters.String(
            "Formula for computing weights:",
            multiline=True,
            default="""+|100|True|type.key
*|0.6| '81530' in {}|components[*].id
*|0.5|'пользователь не видит баг' in {}|userFactor
*|0.9|{} == 'Вспомогательный'|zenFeatureFactor""",
            description="""Формула для автоматического вычисления веса задач
        Для заполнения используется следующий список аргументов:
        1. операция для изменения веса (поддерживаются
        классические мат операции +|-|*|/|**)
        2. значение для изменения веса (значение, на которое изменится
         вес int или float). Можно использовать JsonPath (если в поле содержится число)
        3. Условие, где {} - подставляемое из поля значение
        4. JsonPath к проверяемому полю
        Все описанные аргументы задаются через '|'"""
        )
        force_update = sdk2.parameters.Bool(
            "Force update:",
            default=True,
            description="""Проверять ли наличие значения в тэгах задачи"""
        )
        tag_for_check = sdk2.parameters.String(
            "Tag for check:",
            default='draft',
            description="""Наименование тэга, наличие которого будет проверятся.
Если вышестоящий параметр выключен, то любое проверка будет игнорироваться
"""
        )
        field_for_weight = sdk2.parameters.String(
            "Field for weight:",
            default='weight',
            description="""Поле задачи, в которое будет проставлен вес"""
        )

    def on_execute(self):

        from .utils import prepare_tuple_interval
        from .models import (
            StartrekClient,
            WeightCalculator,
            AutoUpdaterPriority,
            UpdatingFields
        )

        # prepare input parameters
        query: str = self.Parameters.query.strip()
        oauth: str = self.Parameters.oauth.data()['oauth'].strip()
        formula: str = self.Parameters.formula.strip()
        weights_to_priority = {
            prepare_tuple_interval(self.Parameters.trivial): 'trivial',
            prepare_tuple_interval(self.Parameters.minor): 'minor',
            prepare_tuple_interval(self.Parameters.normal): 'normal',
            prepare_tuple_interval(self.Parameters.critical): 'critical',
            prepare_tuple_interval(self.Parameters.blocker): 'blocker'
        }
        field_for_weight = self.Parameters.field_for_weight.strip()
        tag_for_check = self.Parameters.tag_for_check.strip()
        force_update = self.Parameters.force_update

        startrek_client = StartrekClient(oauth)
        calculator = WeightCalculator(formula)
        fields = UpdatingFields(field_for_weight, force_update, tag_for_check)
        updater = AutoUpdaterPriority(
            startrek_client, calculator, fields, weights_to_priority
        )
        updater.update_priority(query)
